<?php
require_once('utility.php');

function save_esxi_conf_to_usbx() {
    global $DTASCFG_XML_FILE ;
    
    $xml     = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    $usbxcli = chop( $xml -> u_sandbox -> cli_path ) ;
    
    $esxi_ip       = chop( $xml -> esxi -> ip ) ;
    $esxi_username = chop( $xml -> esxi -> username ) ;
    $esxi_password =       $xml -> esxi -> password ;

    try {
    
        debug_print( "SetEsxiForUsbx: ip='$esxi_ip', username='$esxi_username'" ) ;
        $ret_array = run_program_at_sc_by_ssh( array(
            'program'   => "/usr/bin/python", 
            'arguments' => array(
                $usbxcli,   "set-esxi",
                "--host",   trim( $esxi_ip ),
                "--user",   trim( $esxi_username ),
                "--passwd",       $esxi_password ) ) ,
            array('--user', '--passwd')
        ) ;
        $retCode      = $ret_array[ 0 ] ;
        $stdoutMsgAry = $ret_array[ 1 ] ;
        $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
        if( $retCode != 0 ) {
            $stderrMsgAry = $ret_array[ 2 ] ;
            $stderrMsg    = join( "\n", $stderrMsgAry ) ;
            throw new Exception( "SetEsxiForUsbxFail: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
        }
        debug_print( "SetEsxiForUsbxSuccess: $stdoutMsg" ) ;
    }

    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        shm_print_error( $msg ) ;
        debug_print( "Exception caught: $msg" ) ;
        exit( 1 ) ;
    }
    
    return ;
}

